VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsScriptSupport"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'////////////////////////////////////////////////////////////////////////////////////////
'// MirageBot Shared Scripting Class
'//
'// ScriptSupportClass.cls
'//
'// This class basically mirrors the signatures of several important MirageBot functions
'// for the purpose of allowing your scripts to interact with the rest of the program.
'//
'// This class is still under construction and is highly based off of StealthBot's SSC
'// class.  If you would like to see more features here please post your ideas on
'// http://www.bnetdev.net :)
'////////////////////////////////////////////////////////////////////////////////////////

'// Index of the current Bot Object
Public Index As Integer

'// Library Declarations
Private Declare Function URLDownloadToFile Lib "urlmon" _
    Alias "URLDownloadToFileA" (ByVal pCaller As Long, _
    ByVal szURL As String, ByVal szFileName As String, _
    ByVal dwReserved As Long, ByVal lpfnCB As Long) As Long
Private Declare Function Beep Lib "kernel32" (ByVal dwFreq As Long, ByVal dwDuration As Long) As Long

'////////////////////////////////////////////////////////////////////////////////////////
'// GLOBAL
'////////////////////////////////////////////////////////////////////////////////////////

    '// Shuts down MirageBot
    Public Sub BotClose()
        Unload frmBot
    End Sub


'////////////////////////////////////////////////////////////////////////////////////////
'// PROFILE
'////////////////////////////////////////////////////////////////////////////////////////
        
    '// AddChat routine to append text to chat window
    Public Sub AddChat(ParamArray E())
        OutputTime frmBot.rtbChat(Index)
        Dim I As Integer, C As Integer
        C = UBound(E)
        For I = 0 To C Step 2
            OutputPart frmBot.rtbChat(Index), CLng(E(I)), CStr(E(I + 1))
        Next I
        OutputPart frmBot.rtbChat(Index), 0, vbNewLine
    End Sub
    
    '// Connects the bot. Will disconnect an already-existent connection.
    Public Sub Connect()
        On Error GoTo hErr:
        GetBot.Connect
        Exit Sub
hErr:
        ErrorHandler Err.Description, Erl, "SSC", "Connect"
    End Sub
    
    '// Closes any current connections within the bot.
    Public Sub Disconnect()
        On Error GoTo hErr:
        GetBot.Disconnect
        Exit Sub
hErr:
        ErrorHandler Err.Description, Erl, "SSC", "Disconnect"
    End Sub

    '// Return this 'Bot Object'
    Public Function GetBot()
        On Error GoTo hErr:
        Set GetBot = frmBot.Bot(Index)
        Exit Function
hErr:
        ErrorHandler Err.Description, Erl, "SSC", "GetBot"
    End Function
    
    '// Return this bot's name
    Public Function GetBotName()
        On Error GoTo hErr:
        GetBotName = GetBot.Profile
        Exit Function
hErr:
        ErrorHandler Err.Description, Erl, "SSC", "GetBotName"
    End Function
    
    '// Return YOUR clan rank
    Public Function GetClanRank()
        On Error Resume Next
        GetClanRank = GetBot.Clan.Rank
    End Function
    
    '// Return YOUR clan tag
    Public Function GetClanTag()
        On Error Resume Next
        GetClanTag = GetBot.Clan.Tag
    End Function
    
    '// Return a clan member object
    Public Function GetMember(Username)
        'Member Object Contains:
        ' - Username    As String       // clan members name
        ' - Rank        As Byte         // 0-4 value (0 - initiate, 1 - peon, 2 - grunt, 3 - shaman, 4 - chieftain)
        ' - Online      As Byte         // 0 -- offline, 1 -- online
        ' - Location    As String       // present when location of a clan member is known
        On Error GoTo hErr:
        Dim UI As Integer
        UI = frmBot.Bot(Index).Clan.Find(CStr(Username))
        If UI > -1 Then Set GetMember = GetBot.Clan.GetByIndex(UI)
        Exit Function
hErr:
        ErrorHandler Err.Description, Erl, "SSC", "GetMember"
    End Function
    
    '// Return a clan member object by index
    Public Function GetMemberByIndex(Index)
        'Member Object Contains:
        ' - Username    As String       // clan members name
        ' - Rank        As Byte         // 0-4 value (0 - initiate, 1 - peon, 2 - grunt, 3 - shaman, 4 - chieftain)
        ' - Online      As Byte         // 0 -- offline, 1 -- online
        ' - Location    As String       // present when location of a clan member is known
        On Error GoTo hErr:
        If GetMemberCount >= Index And Index > -1 Then
            Set GetMemberByIndex = GetBot.Clan.GetByIndex(Index)
        End If
        Exit Function
hErr:
        ErrorHandler Err.Description, Erl, "SSC", "GetMemberByIndex"
    End Function
    
    '// Return clan member count
    Public Function GetMemberCount()
        On Error GoTo hErr:
        GetMemberCount = GetBot.Clan.Count
        Exit Function
hErr:
        ErrorHandler Err.Description, Erl, "SSC", "GetMemberCount"
    End Function
    
    '// Return a clan members location
    Public Function GetMemberLocation(Username)
        On Error Resume Next
        GetMemberLocation = GetMember(Username).Location
    End Function
    
    '// Return a clan members online status
    Public Function GetMemberOnline(Username)
        On Error Resume Next
        GetMemberOnline = (GetMember(Username).Online = &H1)
    End Function
    
    '// Return a clan members rank
    Public Function GetMemberRank(Username)
        On Error Resume Next
        GetMemberRank = GetMember(Username).Rank
    End Function
    
    '// Return a user object
    Public Function GetUser(Username)
        'User Object Contains:
        ' - Username           As String    // username (including prefixes/suffixes)
        ' - Flags              As Long      // users flags
        ' - Statstring         As String    // unparsed statstring
        ' - Ping               As Double    // ping value at login
        ' - Client             As String    // 4-character product identifier
        ' - Expansion          As Boolean   // true when D2XP or W3XP (cdkey hashing feature)
        ' - Character          As String    // character name is IsCharacter = true
        ' - Account            As String    // username (no prefixes/suffixes)
        ' - TickJoin           As Double    // time this user has been seen for
        ' - TickTalk           As Double    // last time this user talked
        ' - TickWhisper        As Double    // last time this user whispered you
        ' - IsRepresentative   As Boolean   // true when the user is a representative
        ' - IsOperator         As Boolean   // true when the user is an operator
        ' - IsSpeaker          As Boolean   // true when the user is a speaker
        ' - IsAdministrator    As Boolean   // true when the user is an administrator
        ' - IsPlug             As Boolean   // true when a user has a UDP plug
        ' - IsIgnored          As Boolean   // true when a user is ignored
        ' - IsCharacter        As Boolean   // true when a user has a character prefix on their name
        ' - IsBannable         As Boolean   // true when a user can be banned
        ' - IsInvisible        As Boolean   // true when user was discovered on FlagUpdate event
        ' - IsShown            As Boolean   // false when user is not yet added to listview (flood protect feature)
        ' - IsIdle             As Boolean   // recently idle (light gray in channel)
        ' - IsIdler            As Boolean   // mid-range idle time (gray in channel)
        ' - IsIdlest           As Boolean   // highest idle time (dark gray in channel)
        On Error GoTo hErr:
        Dim UI As Integer
        UI = GetBot.Users.Find(CStr(Username))
        If UI > -1 Then Set GetUser = GetBot.Users.GetByIndex(UI)
        Exit Function
hErr:
        ErrorHandler Err.Description, Erl, "SSC", "GetUser"
    End Function
    
    '// Return a user object by index
    Public Function GetUserByIndex(Index)
        'User Object Contains:
        ' - Username           As String    // username (including prefixes/suffixes)
        ' - Flags              As Long      // users flags
        ' - Statstring         As String    // unparsed statstring
        ' - Ping               As Double    // ping value at login
        ' - Client             As String    // 4-character product identifier
        ' - Expansion          As Boolean   // true when D2XP or W3XP (cdkey hashing feature)
        ' - Character          As String    // character name is IsCharacter = true
        ' - Account            As String    // username (no prefixes/suffixes)
        ' - TickJoin           As Double    // time this user has been seen for
        ' - TickTalk           As Double    // last time this user talked
        ' - TickWhisper        As Double    // last time this user whispered you
        ' - IsRepresentative   As Boolean   // true when the user is a representative
        ' - IsOperator         As Boolean   // true when the user is an operator
        ' - IsSpeaker          As Boolean   // true when the user is a speaker
        ' - IsAdministrator    As Boolean   // true when the user is an administrator
        ' - IsPlug             As Boolean   // true when a user has a UDP plug
        ' - IsIgnored          As Boolean   // true when a user is ignored
        ' - IsCharacter        As Boolean   // true when a user has a character prefix on their name
        ' - IsBannable         As Boolean   // true when a user can be banned
        ' - IsInvisible        As Boolean   // true when user was discovered on FlagUpdate event
        ' - IsShown            As Boolean   // false when user is not yet added to listview (flood protect feature)
        ' - IsIdle             As Boolean   // recently idle (light gray in channel)
        ' - IsIdler            As Boolean   // mid-range idle time (gray in channel)
        ' - IsIdlest           As Boolean   // highest idle time (dark gray in channel)
        On Error GoTo hErr:
        If GetUserCount <= Index And Index > -1 Then
            Set GetUserByIndex = GetBot.Users.GetByIndex(Index)
        End If
        Exit Function
hErr:
        ErrorHandler Err.Description, Erl, "SSC", "GetUserByIndex"
    End Function
    
    '// Return count of users in channel
    Public Function GetUserCount()
        On Error Resume Next
        GetUserCount = GetBot.Users.Count
    End Function
    
    '// Return a users cached flags
    Public Function GetUserFlags(Username)
        On Error Resume Next
        GetUserFlags = GetUser(Username).Flags
        If Err Then GetUserFlags = -2
    End Function
    
    '// Return a users cached ping
    Public Function GetUserPing(Username)
        On Error Resume Next
        GetUserPing = GetUser(Username).Ping
        If Err Then GetUserPing = -2
    End Function
    
    '// Return a users rank
    Public Function GetUserRank(Username)
        On Error GoTo hErr:
        Dim UI As Integer
        UI = GetBot.Database.Find(CStr(Username))
        If UI > -1 Then GetUserRank = GetRankByID(GetBot.Database.GetUser(UI).RankID).RankName
        Exit Function
hErr:
        ErrorHandler Err.Description, Erl, "SSC", "GetUserRank"
    End Function
    
    '// Shortcut to GetRankLevel(GetUserRank(Username))
    Public Function GetUserLevel(Username)
        On Error GoTo hErr:
        Dim Rank As String
        Rank = GetUserRank(Username)
        If LenB(Rank) Then
            GetUserLevel = GetRankLevel(Rank)
        Else
            GetUserLevel = 0
        End If
        Exit Function
hErr:
        ErrorHandler Err.Description, Erl, "SSC", "GetUserLevel"
    End Function
    
    '// Returns true when you are in a clan
    Public Function IsClanned()
        On Error Resume Next
        IsClanned = GetBot.Clan.InClan
    End Function
    
    '// Return true if user is in a FLAGGED rank
    Public Function IsFlagged(Username)
        On Error Resume Next
        IsFlagged = getRanking(GetUserRank(CStr(Username))).Flagged
    End Function
    
    '// Returns true when you are connected to Battle.net
    Public Function IsOnline()
        On Error Resume Next
        IsOnline = GetBot.IsOnline
    End Function
    
    '// Returns true when you are able to moderate other users
    Public Function IsOps()
        On Error Resume Next
        IsOps = GetBot.Self.IsOperator
    End Function
    
    '// Return true if user is in a SAFE rank
    Public Function IsSafe(Username)
        On Error Resume Next
        IsSafe = getRanking(GetUserRank(CStr(Username))).Safe
    End Function
    
    '// Return the rank's alternative name (usually a letter)
    Public Function GetRankAlias(RankName)
        On Error Resume Next
        GetRankAlias = getRanking(CStr(RankName)).Alias
    End Function
    
    '// Plugin Level will return a value (0-3, 3 = highest) which can be useful
    '// when trying to differentiate between different options depending on a users'
    '// ranked 'Plugin Level'. (See Rank Editor)
    Public Function GetRankLevel(RankName)
        On Error Resume Next
        GetRankLevel = getRanking(CStr(RankName)).Plugin
    End Function
    
    '// Get an array list containing the Ranks this user is capable of Managing
    '// This means they are able to /add, /remove users with any one of these array items
    '// These are from the 'manages' field in the Rank Editor.
    Public Function GetRankManages(RankName) As String()
        On Error Resume Next
        GetRankManages = getRanking(CStr(RankName)).Manages
    End Function
    
    '// Get an array list containing the Ranks this user Inherits
    '// These are from the 'inherits' field in the Rank Editor.
    Public Function GetRankInherits(RankName) As String()
        On Error Resume Next
        GetRankInherits = getRanking(CStr(RankName)).Inherits
    End Function
    
    '// Determines whether this rank is able to access Console commands
    '// Console is usually the highest capable rank and can be used in
    '// scripts to differentiate between multiple users.
    Public Function IsConsole(RankName)
        On Error Resume Next
        IsConsole = getRanking(CStr(RankName)).Console
    End Function
    
    '// Remove current item from the Queue
    Public Sub VetoThisMessage()
        frmBot.Bot(Index).VetoQueuedItem
    End Sub
    
    '// Send message to Battle.net via the Queue
    Public Sub send(Message)
        On Error Resume Next
        frmBot.Bot(Index).SendText CStr(Message)
    End Sub





'////////////////////////////////////////////////////////////////////////////////////////
'// MISCELLANEOUS
'////////////////////////////////////////////////////////////////////////////////////////
    
    '// Executes a call to the Beep() API function
    Public Function DoBeep(lFreq, lDuration)
        DoBeep = Beep(CLng(lFreq), CLng(lDuration))
    End Function

    '// Executes a call to MirageBot's FlashWindowEx() API function
    Public Sub DoFlashWindow()
        Call FlashWindow
    End Sub

    '// Pings specified server IP
    Public Function DoPing(Server)
        DoPing = PingServer(CStr(Server))
    End Function
    
    '// Play a sound from file using the PlaySound() API call
    Public Function DoPlaySound(sFilePath, Optional lFlags = SND_FILENAME Or SND_ASYNC)
        DoPlaySound = PlaySound(CStr(sFilePath), CLng(lFlags))
    End Function

    '// Since Replace does not work in VBS you can use this instead.
    Public Function DoReplace(rExpression, rFind, rReplace, Optional rStart = 1, Optional rCount = -1, Optional rCompare As VbCompareMethod = 0)
        DoReplace = CVar(Replace$(CStr(rExpression), CStr(rFind), CStr(rReplace), CLng(rStart), CLng(rCount), rCompare))
    End Function
    
    '// Kernel32's Sleep Function
    Public Sub DoSleep(dwMilliseconds)
        Call Sleep(CLng(dwMilliseconds))
    End Sub

    '// Return App Version
    Public Function GetAppVersion()
        GetAppVersion = "MirageBot " & App.Major & "." & App.Minor & " by Chriso"
    End Function

    '// Return users clan from their statstring
    Public Function GetClanName(Statstring)
        GetClanName = modStatstringParsing.GetClanName(CStr(Statstring))
    End Function
    
    '// Return clients full name using the ProductID
    Public Function GetClientName(product)
        GetClientName = modStatstringParsing.GetClientName(CStr(product))
    End Function
    
    '// Return users parsed statstring
    Public Function GetClientStats(Statstring)
        GetClientStats = modStatstringParsing.GetClientStats(CStr(Statstring))
    End Function

    '// Return users WarCraft III tier (ie O1) from their statstring
    Public Function GetClientTier(Statstring)
        GetClientTier = modStatstringParsing.GetTier(CStr(Statstring))
    End Function

    '// Return users wins for SC/W2
    Public Function GetClientWins(Statstring)
        GetClientWins = CStr(modStatstringParsing.GetWins(CStr(Statstring)))
    End Function

    '// Returns the current system uptime in milliseconds as reported by the GetTickCount() API call extended using
    '   Kernel32s QueryPerformanceCounter/QueryPerformanceFrequency API calls
    Public Function GetTickCount()
        GetTickCount = DblTickCount()
    End Function
    
    '// Register an Error in MirageBot so users can debug...
    Public Sub HandleError(Description)
        frmBot.mnuError.Visible = True
        Dim FF As Integer
        FF = FreeFile
        Open AppData & "ErrorLog.txt" For Append As #FF
            Print #FF, App.Major & "." & App.Minor & "." & App.Revision & "::SSC::" & Description
        Close #FF
    End Sub
    
    '// Pattern match two strings, e.g. strText = WarBot, strMatch = War*    Matches = (WarBot Like War*)  [True]
    Public Function Matches(strText, strMatch)
        If Len(strText) = 0 Then Exit Function
        Call PrepareCheck(CStr(strMatch))
        Matches = (LCase$(CStr(strText)) Like LCase$(CStr(strMatch)))
    End Function



'////////////////////////////////////////////////////////////////////////////////////////
'// TIMERS
'////////////////////////////////////////////////////////////////////////////////////////

    '// Add a timer to execute on Callback_Procedure every [Interval] milliseconds
    Public Function AddTimer(Callback_Procedure, Interval, Optional Enabled = True)
        On Error GoTo hErr:
        If GetTimer(Callback_Procedure) Is Nothing Then
1           Dim T As New clsScriptTimer
2           T.Callback = CStr(Callback_Procedure)
3           T.Interval = CDbl(Interval)
4           T.Enabled = CBool(Enabled)
5           GetBot.Timers.Add T
            AddTimer = True
        End If
        Exit Function
hErr:
        ErrorHandler Err.Description, Erl, "SSC", "AddTimer"
    End Function
    
    '// Remove timer
    Public Sub DeleteTimer(Callback_Procedure)
        On Error GoTo hErr:
        Dim I As Integer, T As clsScriptTimer
        I = 1
1       For Each T In GetBot.Timers
2           If LCase$(T.Callback) = LCase$(CStr(Callback_Procedure)) Then
3               GetBot.Timers.Remove I
                Exit Sub
            End If
            I = I + 1
        Next T
        Exit Sub
hErr:
        ErrorHandler Err.Description, Erl, "SSC", "DeleteTimer"
    End Sub
    
    '// Execute a timers Callback_Procedure ahead of time
    Public Sub CallTimer(Callback_Procedure)
        On Error GoTo hErr:
        Dim T As Object
1       Set T = GetTimer(CStr(Callback_Procedure))
2       If Not T Is Nothing Then
3           GetBot.CallProcedure T.Callback
        End If
        Exit Sub
hErr:
        ErrorHandler Err.Description, Erl, "SSC", "CallTimer"
    End Sub
    
    '// Change a timers settings
    Public Sub EditTimer(Callback_Procedure, Interval, Optional Enabled = True)
        On Error GoTo hErr:
        With GetTimer(CStr(Callback_Procedure))
            .Interval = CDbl(Interval)
            .Enabled = CBool(Enabled)
        End With
        Exit Sub
hErr:
        ErrorHandler "Timer callback not found (" & Callback_Procedure & ")", 0, "SSC", "EditTimer"
    End Sub
    
    '// Check to see if a timer exists
    Public Function TimerExists(Callback_Procedure)
        On Error GoTo hErr:
        Dim T As Object
        Set T = GetTimer(CStr(Callback_Procedure))
        TimerExists = (Not T Is Nothing)
        Exit Function
hErr:
        ErrorHandler "Timer callback not found (" & Callback_Procedure & ")", 0, "SSC", "TimerExists"
    End Function
    
    '// Returns true when the timer is running
    Public Function TimerEnabled(Callback_Procedure)
        On Error GoTo hErr:
        TimerEnabled = GetTimer(CStr(Callback_Procedure)).Enabled
        Exit Function
hErr:
        ErrorHandler "Timer callback not found (" & Callback_Procedure & ")", 0, "SSC", "TimerEnabled"
    End Function
    
    '// Returns the timer's interval
    Public Function TimerInterval(Callback_Procedure)
        On Error GoTo hErr:
        TimerInterval = GetTimer(CStr(Callback_Procedure)).Interval
        Exit Function
hErr:
        ErrorHandler "Timer callback not found (" & Callback_Procedure & ")", 0, "SSC", "TimerInterval"
    End Function
    
    '// Starts an existing timer
    Public Sub StartTimer(Callback_Procedure)
        On Error GoTo hErr:
        GetTimer(CStr(Callback_Procedure)).Enabled = True
        Exit Sub
hErr:
        ErrorHandler "Timer callback not found (" & Callback_Procedure & ")", 0, "SSC", "StartTimer"
    End Sub
    
    '// Stops an existing timer
    Public Sub StopTimer(Callback_Procedure)
        On Error GoTo hErr:
        GetTimer(Callback_Procedure).Enabled = False
        Exit Sub
hErr:
        ErrorHandler "Timer callback not found (" & Callback_Procedure & ")", 0, "SSC", "StopTimer"
    End Sub
    
    '// Return Timer Object [INTERNAL]
    Private Function GetTimer(Callback_Procedure)
        On Error GoTo hErr:
        Dim T As clsScriptTimer
        For Each T In GetBot.Timers
            If LCase$(T.Callback) = LCase$(Callback_Procedure) Then
                Set GetTimer = T
                Exit Function
            End If
        Next T
        Set GetTimer = Nothing
        Exit Function
hErr:
        ErrorHandler Err.Description, Erl, "SSC", "GetTimer"
    End Function




'////////////////////////////////////////////////////////////////////////////////////////
'// FILE INPUT/OUTPUT
'////////////////////////////////////////////////////////////////////////////////////////
    
    '// Open specified file for appending and return the 'TextStream' object
    Public Function AppendFile(File, Optional Create = True)
        Dim FSO As New FileSystemObject
        Set AppendFile = FSO.OpenTextFile(CStr(File), ForAppending, CBool(Create))
    End Function

    '// Copy specified file
    Public Sub CopyFile(File, Destination, Optional Overwrite = True)
        Dim FSO As New FileSystemObject
        FSO.CopyFile CStr(File), CStr(Destination), CBool(Overwrite)
    End Sub
    
    '// Copy specified folder
    Public Sub CopyFolder(folder, Destination, Optional Overwrite = True)
        Dim FSO As New FileSystemObject
        FSO.CopyFolder CStr(folder), CStr(Destination), CBool(Overwrite)
    End Sub
    
    '// Create specified file and return a 'TextStream' object
    Public Function CreateFile(File, Optional Overwrite = True, Optional Unicode)
        Dim FSO As New FileSystemObject
        Set CreateFile = FSO.CreateTextFile(CStr(File), CBool(Overwrite), CBool(Unicode))
    End Function

    '// Create specified folder and return 'Folder' object
    Public Function CreateFolder(folder)
        Dim FSO As New FileSystemObject
        Set CreateFolder = FSO.CreateFolder(CStr(folder))
    End Function
    
    '// Delete specified file
    Public Sub DeleteFile(File, Optional Force = True)
        Dim FSO As New FileSystemObject
        Call FSO.DeleteFile(CStr(File), CBool(Force))
    End Sub

    '// Delete specified folder
    Public Sub DeleteFolder(folder, Optional Force = True)
        Dim FSO As New FileSystemObject
        Call FSO.DeleteFolder(CStr(folder), CBool(Force))
    End Sub

    '// Return a 'File' object for the given path
    Public Function GetFile(FilePath)
        Dim FSO As New FileSystemObject
        Set GetFile = FSO.GetFile(FilePath)
    End Function

    '// Return a 'Folder' object for the given path
    Public Function GetFolder(FolderPath)
        Dim FSO As New FileSystemObject
        Set GetFolder = FSO.GetFolder(FolderPath)
    End Function

    '// Returns true when the file exists
    Public Function FileExists(File)
        Dim FSO As New FileSystemObject
        FileExists = FSO.FileExists(CStr(File))
    End Function

    '// Returns true when the file exists
    Public Function FolderExists(folder)
        Dim FSO As New FileSystemObject
        FolderExists = FSO.FolderExists(CStr(folder))
    End Function

    '// Move specified file
    Public Sub MoveFile(File, Destination)
        Dim FSO As New FileSystemObject
        Call FSO.MoveFile(CStr(File), CStr(Destination))
    End Sub

    '// Move specified folder
    Public Sub MoveFolder(folder, Destination)
        Dim FSO As New FileSystemObject
        Call FSO.MoveFolder(CStr(folder), CStr(Destination))
    End Sub

    '// Open specified file for reading and return the 'TextStream' object
    Public Function ReadFile(File, Optional Create = True)
        Dim FSO As New FileSystemObject
        Set ReadFile = FSO.OpenTextFile(CStr(File), ForReading, CBool(Create))
    End Function

    '// Open specified file for writing and return the 'TextStream' object
    Public Function WriteFile(File, Optional Create = True)
        Dim FSO As New FileSystemObject
        Set WriteFile = FSO.OpenTextFile(CStr(File), ForWriting, CBool(Create))
    End Function

    '// Return App.Path
    Public Function GetAppPath()
        GetAppPath = App.Path & "\"
    End Function
        
    '// Return this bot's path
    Public Function GetBotPath()
        On Error GoTo hErr:
        GetBotPath = GetBot.ProfilePath
        GetBotPath = Left$(GetBotPath, InStrRev(GetBotPath, "\"))
        Exit Function
hErr:
        ErrorHandler Err.Description, Erl, "SSC", "GetBotPath"
    End Function

    '// Return AppData\Data\Other Path
    Public Function GetDataPath()
        GetDataPath = AppData & "Data\Other\"
    End Function
    
    '// Return AppData Path
    Public Function GetFilePath()
        GetFilePath = AppData
    End Function
        
    '// Download a file to the %APPDATA%\Data\Other directory
    Public Sub PrintURLToFile(sFileName, sURL)
        sFileName = GetDataPath & sFileName
        URLDownloadToFile 0, CStr(sURL), CStr(sFileName), 0, 0
    End Sub

    '//Return Config.ini Value
    Public Function ReadConfig(Section, Key)
        On Error Resume Next: ReadConfig = modFileIO.ReadINI(GetBotPath, CStr(Section), CStr(Key))
    End Function
    
    '// Return Settings.ini Value
    Public Function ReadSetting(Section, Key)
        On Error Resume Next: ReadSetting = modFileIO.ReadINI(AppSettings, CStr(Section), CStr(Key))
    End Function
    
    '// Return INI Value
    Public Function ReadINI(File, Section, Key)
        On Error Resume Next: ReadINI = modFileIO.ReadINI(CStr(File), CStr(Section), CStr(Key))
    End Function
    
    '// Write Config.ini Value
    Public Sub WriteConfig(Section, Key, Value)
        On Error Resume Next: modFileIO.WriteINI GetBotPath, CStr(Section), CStr(Key), CStr(Value)
    End Sub
    
    '// Write Settings.ini Value
    Public Sub WriteSetting(Section, Key, Value)
        On Error Resume Next: modFileIO.WriteINI AppSettings, CStr(Section), CStr(Key), CStr(Value)
    End Sub

    '// Write INI Value
    Public Sub WriteINI(File, Section, Key, Value)
        On Error Resume Next: modFileIO.WriteINI CStr(File), CStr(Section), CStr(Key), CStr(Value)
    End Sub

    '// Write Profile Keys (2D Array)
    '//   You may write as many keys are you need to change
    '//   Item (,0) = Key
    '//   Item (,1) = Value
    '// Change just location:
    '//   Dim Keys(0, 1) As String
    '//   Keys(0, 0) = "profile\location"
    '//   Keys(0, 1) = "Australia"
    '// Change all keys:
    '//   Dim Keys(3, 1) As String
    '//   Keys(0, 0) = "profile\age"
    '//   Keys(0, 1) = "18"
    '//   Keys(1, 0) = "profile\sex"
    '//   Keys(1, 1) = "Male"
    '//   Keys(2, 0) = "profile\location"
    '//   Keys(2, 1) = "Australia"
    '//   Keys(3, 0) = "profile\description"
    '//   Keys(3, 1) = "MirageBot"
    Public Sub WriteUserProfile(Keys())
        On Error Resume Next: GetBot.SendWriteUserData Keys
    End Sub
